import sql from 'mssql';
import { config } from './config.js';

const findAuthorsByBirthDates = async (startDate, endDate) => {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Call the stored procedure GetAuthorsByBirthDate
    const result = await pool
      .request()
      .input('StartDate', sql.Date, new Date(startDate))
      .input('EndDate', sql.Date, new Date(endDate))
      .execute('GetAuthorsByBirthDate');

    // Return the result
    return result.recordset;
  } catch (err) {
    console.error(err);
  }
};

export { findAuthorsByBirthDates };

const result = await pool
  .request()
  .input('StartDate', sql.Date, new Date(startDate))
  .input('EndDate', sql.Date, new Date(endDate))
  .execute('GetAuthorsByBirthDate');
